/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.persist;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceClassNotFoundException;
import com.ibm.hwmca.fw.persist.PersistenceData;
import com.ibm.hwmca.fw.persist.PersistenceErrorIds;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceInvalidNameException;
import com.ibm.hwmca.fw.persist.PersistenceIsChildException;
import com.ibm.hwmca.fw.persist.PersistenceIsParentException;
import com.ibm.hwmca.fw.persist.PersistencePathNotAvailableException;
import com.ibm.hwmca.fw.persist.PersistencePersistentDataConstructorNotFoundException;
import com.ibm.hwmca.fw.persist.PersistenceReadException;
import com.ibm.hwmca.fw.persist.PersistenceUnsupportedUpgradeDataVersionException;
import com.ibm.hwmca.fw.persist.PersistenceUnsupportedVersionException;
import com.ibm.hwmca.fw.persist.PersistenceWriteException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class PersistenceManager
implements PersistenceErrorIds,
UpgradeData {
    private static final String TRACE_MASKT = "XPERMGRT";
    private static final String TRACE_MASKF = "XPERMGRF";
    private static final String TRACE_MASKD = "XPERMGRD";
    public static final String RECOVERY_FILE = "persistence.recovery";
    private static final String PERSISTENT_DATA_STORE_LOCATION = "persist";
    private static final String TRANSIENT_DATA_STORE_LOCATION = "transient";
    private static final int PERSISTENCE_MANAGER_FIRST_VERSION = 1;
    private static final int PERSISTENCE_MANAGER_VERSION = 1;
    protected static final String PERSISTENCE_MANAGER_FIRST_UPGRADE_VERSION = "1";
    protected static final String PERSISTENCE_MANAGER_UPGRADE_VERSION = "1";
    private static final String GENERATED_KEY_START = "#";
    private static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NUMBERS = "0123456789";
    private static final String MISCCHARS = ".#";
    private static final String ALLOWEDCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.#";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(95, "PersistMgr");
    private static Object pmLock = new Object();
    private static PersistenceManager persistenceManager = null;
    private String _persDataStorePrefix;
    private String _transDataStorePrefix;
    protected boolean _isNotInitialized;
    private PersistenceException _pmNotInitializedException;

    public static synchronized PersistenceManager getPersistenceManager() {
        if (persistenceManager == null) {
            persistenceManager = new PersistenceManager();
            persistenceManager.initialize();
        }
        return persistenceManager;
    }

    public String getTransientDataStore() {
        return this._transDataStorePrefix;
    }

    public void write(String name, PersistentData obj) throws PersistenceIsParentException, PersistenceInvalidNameException, PersistenceWriteException {
        this.write(name, obj, this._persDataStorePrefix);
    }

    public void write(String name, PersistentData obj, String dataStore) throws PersistenceIsParentException, PersistenceInvalidNameException, PersistenceWriteException {
        this.writeIt(name, obj, dataStore);
    }

    public void write(String name, Persistable obj) throws PersistenceIsParentException, PersistenceInvalidNameException, PersistenceWriteException {
        this.write(name, obj, this._persDataStorePrefix);
    }

    public void write(String name, Persistable obj, String dataStore) throws PersistenceIsParentException, PersistenceInvalidNameException, PersistenceWriteException {
        this.writeIt(name, obj, dataStore);
    }

    public String writeChild(String parentId, PersistentData data) throws PersistenceIsChildException, PersistenceInvalidNameException, PersistenceWriteException {
        return this.writeChild(parentId, data, this._persDataStorePrefix);
    }

    public String writeChild(String parentId, PersistentData data, String dataStore) throws PersistenceIsChildException, PersistenceInvalidNameException, PersistenceWriteException {
        return this.writeAChild(parentId, data, dataStore);
    }

    public String writeChild(String parentId, Persistable data) throws PersistenceIsChildException, PersistenceInvalidNameException, PersistenceWriteException {
        return this.writeChild(parentId, data, this._persDataStorePrefix);
    }

    public String writeChild(String parentId, Persistable data, String dataStore) throws PersistenceIsChildException, PersistenceInvalidNameException, PersistenceWriteException {
        return this.writeAChild(parentId, data, dataStore);
    }

    public Object objectToContainedForm(Object object) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKD, "<> PersistenceManager.objectToContainedForm for " + object.getClass().toString());
        if (object instanceof Persistable) {
            return new PersistenceData(object.getClass().getName(), ((Persistable)object).getPersistentData());
        }
        if (object instanceof PersistentData) {
            return object;
        }
        if (object instanceof Serializable) {
            return object;
        }
        IllegalArgumentException exp = new IllegalArgumentException("PersistenceManager.objectToContainedForm: Object is of invalid class: " + object.getClass().toString());
        throw exp;
    }

    public Object containedFormToObject(Object containedForm) throws PersistenceReadException, PersistencePersistentDataConstructorNotFoundException, PersistenceClassNotFoundException {
        Trace.trace(TRACE_MASKD, "<> PersistenceManager.containedFormToObject for " + containedForm.getClass().toString());
        if (containedForm instanceof PersistenceData) {
            return PersistenceManager.createPersistable(((PersistenceData)containedForm).getPersistableClass(), ((PersistenceData)containedForm).getPersistentData(), null);
        }
        return containedForm;
    }

    public Object read(String name) throws PersistenceIsParentException, PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        return this.read(name, this._persDataStorePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object read(String name, String dataStore) throws PersistenceIsParentException, PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Object reconstitutedObject;
        block6: {
            Trace.trace(TRACE_MASKT, "> PersistenceManager.read name: " + name);
            if (this._isNotInitialized) {
                Trace.trace(TRACE_MASKF, "PersistenceManager.read: PersistenceManager was not correct initialized!!!");
                throw new PersistenceReadException(this._pmNotInitializedException);
            }
            reconstitutedObject = null;
            File file = null;
            Object object = pmLock;
            // MONITORENTER : object
            file = this.lookup(name, dataStore);
            // MONITOREXIT : object
            if (file != null) {
                if (file.isFile() && file.length() > 0L) {
                    reconstitutedObject = this.decode(file, this.fileNameToName(name, dataStore));
                    break block6;
                } else {
                    String errorMsg = "PersistenceManager.read: Error! Passed name " + name + " is a directory!";
                    Trace.trace(TRACE_MASKF, "File is Parent! Error!");
                    Trace.trace(TRACE_MASKF, errorMsg);
                    PersistenceIsParentException pexp = new PersistenceIsParentException(errorMsg);
                    throw pexp;
                }
            }
            Trace.trace(TRACE_MASKT, "PersistenceManager.read: could not find file, returning NULL! Passed name: " + name);
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.read");
        return reconstitutedObject;
    }

    public List readChildrenNames(String name) throws PersistenceReadException {
        return this.readChildrenNames(name, this._persDataStorePrefix);
    }

    public List readChildrenNames(String name, String dataStore) throws PersistenceReadException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.readChildrenNames of: " + name);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.readChildrenNames: PersistenceManager was not correct initialized!!!");
            throw new PersistenceReadException(this._pmNotInitializedException);
        }
        ArrayList<String> childNameList = new ArrayList<String>();
        File file = this.lookup(name, dataStore);
        if (file != null && file.isDirectory()) {
            File[] files = file.listFiles();
            int noOfFiles = files.length;
            childNameList.ensureCapacity(noOfFiles);
            for (int i = 0; i < noOfFiles; ++i) {
                if (!files[i].isFile()) continue;
                childNameList.add(this.fileNameToName(files[i].getAbsolutePath(), dataStore));
            }
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.readChildrenNames, size: " + childNameList.size());
        return childNameList;
    }

    public List readChildrenNamesRecursive(String name) throws PersistenceReadException {
        return this.readChildrenNamesRecursive(name, this._persDataStorePrefix);
    }

    public List readChildrenNamesRecursive(String name, String dataStore) throws PersistenceReadException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.readChildrenNamesRecursive of: " + name);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.readChildrenNamesRecursive: PersistenceManager was not correct initialized!!!");
            throw new PersistenceReadException(this._pmNotInitializedException);
        }
        ArrayList<String> childNameList = new ArrayList<String>();
        File file = this.lookup(name, dataStore);
        if (file != null && file.isDirectory()) {
            File[] childFiles = file.listFiles();
            int noOfFiles = childFiles.length;
            childNameList.ensureCapacity(noOfFiles);
            for (int i = 0; i < noOfFiles; ++i) {
                if (childFiles[i].isDirectory()) {
                    childNameList.addAll(this.readChildrenNamesRecursive(childFiles[i].getAbsolutePath(), dataStore));
                    continue;
                }
                childNameList.add(this.fileNameToName(childFiles[i].getAbsolutePath(), dataStore));
            }
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.readChildrenNamesRecursive, size: " + childNameList.size());
        return childNameList;
    }

    public List readParentNames(String grandparent) throws PersistenceReadException {
        return this.readParentNames(grandparent, this._persDataStorePrefix);
    }

    public List readParentNames(String grandparent, String dataStore) throws PersistenceReadException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.readParentNames of: " + grandparent);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.readParentNames: PersistenceManager was not correct initialized!!!");
            throw new PersistenceReadException(this._pmNotInitializedException);
        }
        ArrayList<String> parentNameList = new ArrayList<String>();
        File file = this.lookup(grandparent, dataStore);
        if (file != null && file.isDirectory()) {
            File[] files = file.listFiles();
            int noOfFiles = files.length;
            parentNameList.ensureCapacity(noOfFiles);
            for (int i = 0; i < noOfFiles; ++i) {
                if (!files[i].isDirectory()) continue;
                String parentFileName = files[i].getAbsolutePath();
                parentNameList.add(this.fileNameToName(parentFileName, dataStore));
            }
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.readParentNames, size: " + parentNameList.size());
        return parentNameList;
    }

    public Map readChildren(String name) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        return this.readChildren(name, this._persDataStorePrefix);
    }

    public Map readChildren(String name, String dataStore) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Trace.trace(TRACE_MASKT, "<> PersistenceManager.readChildren of: " + name);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.readChildren: PersistenceManager was not correct initialized!!!");
            throw new PersistenceReadException(this._pmNotInitializedException);
        }
        return this.readList(this.readChildrenNames(name, dataStore), dataStore);
    }

    public Map readChildrenRecursive(String name) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        return this.readChildrenRecursive(name, this._persDataStorePrefix);
    }

    public Map readChildrenRecursive(String name, String dataStore) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Trace.trace(TRACE_MASKT, "<> PersistenceManager.readChildrenRecursive of: " + name);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.readChildrenRecursive: PersistenceManager was not correct initialized!!!");
            throw new PersistenceReadException(this._pmNotInitializedException);
        }
        return this.readList(this.readChildrenNamesRecursive(name, dataStore), dataStore);
    }

    public boolean delete(String name) {
        return this.delete(name, this._persDataStorePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String name, String dataStore) {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.delete object with name: " + name);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.delete: PersistenceManager was not correct initialized!!!");
            return false;
        }
        boolean deleted = false;
        Object object = pmLock;
        synchronized (object) {
            File file = this.lookup(name, dataStore);
            if (file != null) {
                deleted = file.delete();
            }
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.delete: " + deleted);
        return deleted;
    }

    public boolean deleteChildren(String parentName) {
        return this.deleteChildren(parentName, this._persDataStorePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteChildren(String parentName, String dataStore) {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.deleteChildren of: " + parentName);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.deleteChildren: PersistenceManager was not correct initialized!!!");
            return false;
        }
        boolean deleted = true;
        Object object = pmLock;
        synchronized (object) {
            File file = this.lookup(parentName, dataStore);
            if (file != null && file.isDirectory()) {
                File[] children = file.listFiles();
                int noOfFiles = children.length;
                for (int i = 0; i < noOfFiles; ++i) {
                    if (!children[i].isFile() || children[i].delete()) continue;
                    deleted = false;
                }
            } else {
                deleted = false;
            }
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.deleteChildren: " + deleted);
        return deleted;
    }

    public boolean deleteChildrenRecursive(String parentName) {
        return this.deleteChildrenRecursive(parentName, this._persDataStorePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteChildrenRecursive(String parentName, String dataStore) {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.deleteChildrenRecursive of: " + parentName);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.deleteChildrenRecursive: PersistenceManager was not correct initialized!!!");
            return false;
        }
        boolean deleted = true;
        Object object = pmLock;
        synchronized (object) {
            File file = this.lookup(parentName, dataStore);
            if (file != null && file.isDirectory()) {
                File[] children = file.listFiles();
                int noOfFiles = children.length;
                for (int i = 0; i < noOfFiles; ++i) {
                    if (children[i].isFile()) {
                        if (children[i].delete()) continue;
                        deleted = false;
                        continue;
                    }
                    if (!children[i].isDirectory()) continue;
                    deleted = this.deleteChildrenRecursive(children[i].getAbsolutePath(), dataStore);
                }
            } else {
                deleted = false;
            }
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.deleteChildrenRecursive: " + deleted);
        return deleted;
    }

    public boolean contains(String name) {
        return this.contains(name, this._persDataStorePrefix);
    }

    public boolean contains(String name, String dataStore) {
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.contains: PersistenceManager was not correct initialized!!!");
            return false;
        }
        File file = this.lookup(name, dataStore);
        return file != null;
    }

    public boolean containsChild(String name) {
        return this.containsChild(name, this._persDataStorePrefix);
    }

    public boolean containsChild(String name, String dataStore) {
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.containsChild: PersistenceManager was not correct initialized!!!");
            return false;
        }
        File file = this.lookup(name, dataStore);
        return file != null && !file.isDirectory();
    }

    public boolean isChild(String name) {
        return this.isChild(name, this._persDataStorePrefix);
    }

    public boolean isChild(String name, String dataStore) {
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.isChild: PersistenceManager was not correct initialized!!!");
            return false;
        }
        File file = this.lookup(name, dataStore);
        return file != null && file.isFile();
    }

    public boolean isParent(String name) {
        return this.isParent(name, this._persDataStorePrefix);
    }

    public boolean isParent(String name, String dataStore) {
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.isParent: PersistenceManager was not correct initialized!!!");
            return false;
        }
        File file = this.lookup(name, dataStore);
        return file != null && file.isDirectory();
    }

    public boolean hasChildren(String name) {
        return this.hasChildren(name, this._persDataStorePrefix);
    }

    public boolean hasChildren(String name, String dataStore) {
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.hasChildren: PersistenceManager was not correct initialized!!!");
            return false;
        }
        File file = this.lookup(name, dataStore);
        return file != null && file.isDirectory() && file.list().length > 0;
    }

    public static byte[] encode(Persistable persistableObject) throws PersistenceWriteException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.encode (Persistable)");
        PersistenceData dataToBePersisted = new PersistenceData(persistableObject.getClass().getName(), persistableObject.getPersistentData());
        byte[] encoding = PersistenceManager.encode(dataToBePersisted, persistableObject.isUpgradeData());
        Trace.trace(TRACE_MASKT, "< PersistenceManager.encode (Persistable)");
        return encoding;
    }

    public static byte[] encode(PersistentData persistentObject) throws PersistenceWriteException {
        return PersistenceManager.encode(persistentObject, false);
    }

    public static Object decode(byte[] objectRepresentation) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.decode(byte[])");
        Object reconstitutedObject = null;
        try {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(objectRepresentation);
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            reconstitutedObject = PersistenceManager.decode(objectInput, null);
            byteInput.close();
            objectInput.close();
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.decode(byte[]): Could not decode!");
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            PersistenceReadException pexp = new PersistenceReadException(exp);
            new FrameworkLog(classLogInfo, 17, exp).log();
            throw pexp;
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.decode(byte[])");
        return reconstitutedObject;
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        return "1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpgradeData(OutputStream outStream) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.saveUpgradeData (all)");
        boolean closeStream = false;
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.readUpgradeData: PersistenceManager was not correct initialized!!!");
            UpgradeDataException upgradeException = new UpgradeDataException(this._pmNotInitializedException);
            upgradeException.setCriticalDataError();
            throw upgradeException;
        }
        String failingNames = new String();
        try {
            Object object = pmLock;
            synchronized (object) {
                List allNames = this.readChildrenNamesRecursive(this._persDataStorePrefix);
                ZipOutputStream zipStream = new ZipOutputStream(outStream);
                Iterator it = allNames.iterator();
                while (it.hasNext()) {
                    String nextName = (String)it.next();
                    try {
                        if (!this.saveUpgradeData(zipStream, nextName)) continue;
                        closeStream = true;
                    }
                    catch (IOException exp) {
                        Trace.trace(TRACE_MASKF, "An error occurred during saveUpgradeData of: " + nextName);
                        Trace.trace(TRACE_MASKF, exp);
                        failingNames = failingNames + "Name: " + nextName + " Error: " + exp + "\n";
                    }
                }
                if (closeStream) {
                    zipStream.close();
                } else {
                    Trace.trace(TRACE_MASKF, "No ZipEntry written, do not close ZipStream.");
                }
            }
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "IO error during saveUpgradeData: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            UpgradeDataException upgradeExp = new UpgradeDataException(exp);
            new FrameworkLog(classLogInfo, 48, exp).log();
            throw upgradeExp;
        }
        catch (PersistenceReadException exp) {
            Trace.trace(TRACE_MASKF, "Read error during saveUpgradeData");
            Trace.trace(TRACE_MASKF, exp);
            UpgradeDataException upgradeExp = new UpgradeDataException(exp);
            new FrameworkLog(classLogInfo, 48, exp).log();
            throw upgradeExp;
        }
        if (failingNames.length() > 0) {
            if (failingNames.length() > 10000) {
                failingNames = failingNames.substring(0, 10000);
            }
            String errorMsg = "An error occurred during saveUgradeData(). The following objects could not be saved: \n" + failingNames;
            UpgradeDataException upgradeExp = new UpgradeDataException(errorMsg);
            FrameworkLog log = new FrameworkLog(classLogInfo, 48, upgradeExp);
            log.add(errorMsg);
            log.log();
            throw upgradeExp;
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.saveUpgradeData (all)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUpgradeData(InputStream inStream, String version) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.restoreUpgradeData for Version: " + version);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.restoreUpgradeData: PersistenceManager was not correct initialized!!!");
            UpgradeDataException upgradeException = new UpgradeDataException(this._pmNotInitializedException);
            upgradeException.setCriticalDataError();
            throw upgradeException;
        }
        if (!version.equals("1")) {
            String errorMsg = "PersistenceManager.restoreUpgradeData: Unsupported upgrade version found: " + version + " Expected version: " + "1";
            Trace.trace(TRACE_MASKF, errorMsg);
            PersistenceUnsupportedUpgradeDataVersionException pexp = new PersistenceUnsupportedUpgradeDataVersionException(errorMsg);
            new FrameworkLog(classLogInfo, 49, pexp).log();
            UpgradeDataException upgradeException = new UpgradeDataException(pexp);
            upgradeException.setCriticalDataError();
            throw upgradeException;
        }
        String failingNames = new String();
        try {
            Object pexp = pmLock;
            synchronized (pexp) {
                ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(inStream));
                boolean moreEntries = true;
                while (moreEntries) {
                    ZipEntry entry = zipStream.getNextEntry();
                    if (entry == null) {
                        moreEntries = false;
                        continue;
                    }
                    try {
                        this.restoreUpgradeData(zipStream, entry);
                    }
                    catch (IOException exp) {
                        Trace.trace(TRACE_MASKF, "An error occurred during restoreUpgradeData of: " + entry.getName());
                        Trace.trace(TRACE_MASKF, "Error message: " + exp.getMessage());
                        Trace.trace(TRACE_MASKF, exp);
                        failingNames = failingNames + "Name: " + entry.getName() + " Error: " + exp.getMessage() + "\n";
                    }
                }
                zipStream.close();
            }
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "IO error during restoreUpgradeData: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            UpgradeDataException upgradeExp = new UpgradeDataException(exp);
            new FrameworkLog(classLogInfo, 49, exp).log();
            throw upgradeExp;
        }
        if (failingNames.length() > 0) {
            if (failingNames.length() > 10000) {
                failingNames = failingNames.substring(0, 10000);
            }
            String errorMsg = "An error occurred during restoreUgradeData(). The following objects could not be restored: " + failingNames;
            UpgradeDataException upgradeExp = new UpgradeDataException(errorMsg);
            FrameworkLog log = new FrameworkLog(classLogInfo, 49, upgradeExp);
            log.add(failingNames);
            log.log();
            throw upgradeExp;
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.restoreUpgradeData");
    }

    protected void initialize() {
        String dataStorePrefix = null;
        String transDataStorePrefix = null;
        try {
            String driveLetter;
            String userDir;
            BaseFileControl.makeFilePath(PERSISTENT_DATA_STORE_LOCATION);
            dataStorePrefix = BaseFileControl.getFilePath(PERSISTENT_DATA_STORE_LOCATION);
            if (!CommonSystem.getCommonSystem().isLinux()) {
                if (dataStorePrefix.charAt(1) == ':') {
                    this._persDataStorePrefix = dataStorePrefix;
                } else {
                    userDir = System.getProperty("user.dir");
                    driveLetter = userDir.substring(0, 2);
                    this._persDataStorePrefix = driveLetter + dataStorePrefix;
                }
            } else {
                this._persDataStorePrefix = dataStorePrefix;
            }
            Trace.trace(TRACE_MASKF, "<> PersistenceManager.getPersistenceManager: persistent data store path is: " + dataStorePrefix);
            BaseFileControl.makeFilePath(TRANSIENT_DATA_STORE_LOCATION);
            transDataStorePrefix = BaseFileControl.getFilePath(TRANSIENT_DATA_STORE_LOCATION);
            if (!CommonSystem.getCommonSystem().isLinux()) {
                userDir = System.getProperty("user.dir");
                driveLetter = userDir.substring(0, 2);
                this._transDataStorePrefix = driveLetter + transDataStorePrefix;
            } else {
                this._transDataStorePrefix = transDataStorePrefix;
            }
            Trace.trace(TRACE_MASKF, "<> PersistenceManager.getPersistenceManager: transient data store path is: " + transDataStorePrefix);
            this._isNotInitialized = false;
        }
        catch (HException exp) {
            String errorText = "PersistenceManager.getPersistenceManager: Could not get Persistence Data Store path!";
            Trace.trace(TRACE_MASKF, errorText);
            Trace.trace(TRACE_MASKF, "Got Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            this._pmNotInitializedException = new PersistencePathNotAvailableException(exp);
            this._persDataStorePrefix = "invalid";
            this._transDataStorePrefix = "invalid";
            this._isNotInitialized = true;
            new FrameworkLog(classLogInfo, 0, this._pmNotInitializedException).log();
        }
        if (!this._isNotInitialized) {
            try {
                String recoveryFile = BaseFileControl.getFilePath(RECOVERY_FILE) + File.separator + RECOVERY_FILE;
                Trace.trace(TRACE_MASKF, "Checking for file ('" + recoveryFile + "').");
                File recovery = new File(recoveryFile);
                if (recovery.exists()) {
                    Trace.trace(TRACE_MASKF, "Recovery file exists, loading.");
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(recovery), 10240);
                    this.restoreUpgradeData(is, "1");
                    Trace.trace(TRACE_MASKF, "Load completes.");
                    try {
                        Trace.trace(TRACE_MASKF, "Attempting delete of recovery file.");
                        recovery.delete();
                    }
                    catch (SecurityException e) {
                        Trace.trace(TRACE_MASKF, "SecurityException when attempting to delete file.");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Recovery file does not exist, continuing on with normal processing.");
                }
            }
            catch (FileNotFoundException e) {
                Trace.trace(TRACE_MASKF, "FileNotFoundException trying restore from recovery file.");
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKF, "HException trying restore from recovery file.");
            }
        }
    }

    protected PersistenceManager() {
    }

    private static byte[] encode(Object object, boolean isUpgradeData) throws PersistenceWriteException {
        byte[] objectEncoding;
        Trace.trace(TRACE_MASKT, "> PersistenceManager.encode(Object); is UpgradeData: " + isUpgradeData);
        Class<?> persClass = object.getClass();
        try {
            if (object instanceof PersistenceData) {
                persClass = ((PersistenceData)object).getPersistentData().getClass();
            }
            persClass.getDeclaredField("serialVersionUID");
        }
        catch (NoSuchFieldException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.encode: No serialVersionUID defined!");
            Trace.trace(TRACE_MASKF, "Missing in Class: " + persClass.getName());
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            PersistenceWriteException pexp = new PersistenceWriteException(exp);
            throw pexp;
        }
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(byteArrayStream);
            objectOutput.writeInt(1);
            objectOutput.writeBoolean(isUpgradeData);
            objectOutput.writeObject(object);
            objectOutput.close();
            objectEncoding = byteArrayStream.toByteArray();
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.encode: Could not encode!");
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, "Object: " + object.toString());
            Trace.trace(TRACE_MASKF, exp);
            PersistenceWriteException pexp = new PersistenceWriteException(exp);
            new FrameworkLog(classLogInfo, 33, exp).log();
            throw pexp;
        }
        Trace.trace(TRACE_MASKT, "< PersistenceManager.encode(Object)");
        return objectEncoding;
    }

    private Object decode(File objectRepresentation, String persistentKey) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Trace.trace(TRACE_MASKF, "> PersistenceManager.decode key: " + persistentKey);
        Object reconstitutedObject = null;
        try {
            FileInputStream fileInput = new FileInputStream(objectRepresentation);
            ObjectInputStream objectInput = new ObjectInputStream(fileInput);
            reconstitutedObject = PersistenceManager.decode(objectInput, persistentKey);
            fileInput.close();
            objectInput.close();
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.decode(File): Could not decode!");
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            PersistenceReadException pexp = new PersistenceReadException(exp);
            new FrameworkLog(classLogInfo, 17, exp).log();
            throw pexp;
        }
        Trace.trace(TRACE_MASKF, "< PersistenceManager.decode(File)");
        return reconstitutedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object decode(ObjectInputStream objectInput, String persistentKey) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Trace.trace(TRACE_MASKF, "> PersistenceManager.decode(ObjectInputStream)");
        Object decodedObject = null;
        Object reconstitutedObject = null;
        try {
            Object object = pmLock;
            synchronized (object) {
                int version = objectInput.readInt();
                if (version != 1) {
                    String errorMsg = "PersistenceManager.decode: Unsupported version found: " + version + " Expected version: " + 1 + " ObjectKey: " + persistentKey;
                    Trace.trace(TRACE_MASKF, errorMsg);
                    PersistenceUnsupportedVersionException pexp = new PersistenceUnsupportedVersionException(errorMsg);
                    new FrameworkLog(classLogInfo, 20, pexp).log();
                    throw pexp;
                }
                boolean isUpgradeData = objectInput.readBoolean();
                decodedObject = objectInput.readObject();
            }
            reconstitutedObject = decodedObject instanceof PersistenceData ? PersistenceManager.createPersistable(((PersistenceData)decodedObject).getPersistableClass(), ((PersistenceData)decodedObject).getPersistentData(), persistentKey) : decodedObject;
        }
        catch (ClassNotFoundException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.decode: Could not decode (ClassNotFoundException)!");
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, "PersistentKey: " + persistentKey);
            Trace.trace(TRACE_MASKF, exp);
            PersistenceClassNotFoundException pexp = new PersistenceClassNotFoundException(exp);
            new FrameworkLog(classLogInfo, 18, exp).log();
            throw pexp;
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.decode: Could not decode (IOException)!");
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, "PersistentKey: " + persistentKey);
            Trace.trace(TRACE_MASKF, exp);
            PersistenceReadException pexp = new PersistenceReadException(exp);
            new FrameworkLog(classLogInfo, 16, exp).log();
            throw pexp;
        }
        Trace.trace(TRACE_MASKF, "< PersistenceManager.decode(ObjectInputStream)");
        return reconstitutedObject;
    }

    private static Persistable createPersistable(String storingClassName, PersistentData persistentData, String persistentName) throws PersistenceReadException, PersistencePersistentDataConstructorNotFoundException, PersistenceClassNotFoundException {
        Trace.trace(TRACE_MASKF, "> PersistenceManager.createPersistable for:" + storingClassName + " Name: " + persistentName);
        Persistable persistable = null;
        Constructor<?> persistableConstructor = null;
        Constructor<?> persistableConstructorWithName = null;
        try {
            Class<?> storingClass = Class.forName(storingClassName);
            Class<?> persistentDataClass = Class.forName("com.ibm.hwmca.fw.persist.PersistentData");
            try {
                persistableConstructor = storingClass.getDeclaredConstructor(persistentDataClass);
                persistableConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException exp) {
                Trace.trace(TRACE_MASKF, "PersistenceManager.createPersistable: Could not get one parameter PersistentData Constructor!");
                if (persistentName != null) {
                    persistableConstructorWithName = storingClass.getDeclaredConstructor(persistentDataClass, persistentName.getClass());
                    persistableConstructorWithName.setAccessible(true);
                }
                throw exp;
            }
            if (persistableConstructor != null) {
                Trace.trace(TRACE_MASKF, "PersistenceManager.createPersistable (no key) construct a " + storingClassName);
                persistable = (Persistable)persistableConstructor.newInstance(persistentData);
            } else {
                Trace.trace(TRACE_MASKF, "PersistenceManager.createPersistable (with key) construct a " + storingClassName);
                persistable = (Persistable)persistableConstructorWithName.newInstance(persistentData, persistentName);
            }
        }
        catch (ClassNotFoundException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.createPersistable: Could not decode (ClassNotFoundException)!");
            Trace.trace(TRACE_MASKF, "Failing class is: " + storingClassName);
            Trace.trace(TRACE_MASKF, "Passed Key: " + persistentName);
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            PersistenceClassNotFoundException pexp = new PersistenceClassNotFoundException(exp);
            new FrameworkLog(classLogInfo, 18, exp).log();
            throw pexp;
        }
        catch (NoSuchMethodException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.createPersistable: Could not get PersistentData Constructor!");
            Trace.trace(TRACE_MASKF, "Failing Object Class: " + storingClassName);
            Trace.trace(TRACE_MASKF, "Passed Key: " + persistentName);
            if (persistableConstructor == null) {
                Trace.trace(TRACE_MASKF, "One parameter constructor missing!");
            }
            if (persistableConstructorWithName == null) {
                Trace.trace(TRACE_MASKF, "Two parameter constructor missing!");
            }
            if (persistentData != null) {
                Trace.trace(TRACE_MASKF, "Failing PersistentData: " + persistentData.toString());
            } else {
                Trace.trace(TRACE_MASKF, "PersistentData is null!!!");
            }
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            PersistencePersistentDataConstructorNotFoundException pexp = new PersistencePersistentDataConstructorNotFoundException(exp);
            new FrameworkLog(classLogInfo, 19, exp).log();
            throw pexp;
        }
        catch (Exception exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.createPersistable: Could not create Persistable!");
            Trace.trace(TRACE_MASKF, "Passed Key: " + persistentName);
            Trace.trace(TRACE_MASKF, "Failing Object Class: " + storingClassName);
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            if (persistentData != null) {
                Trace.trace(TRACE_MASKF, "Failing PersistentData: " + persistentData.toString());
            } else {
                Trace.trace(TRACE_MASKF, "PersistentData is null!!!");
            }
            Trace.trace(TRACE_MASKF, exp);
            PersistenceReadException pexp = new PersistenceReadException(exp);
            throw pexp;
        }
        Trace.trace(TRACE_MASKF, "< PersistenceManager.createPersistable");
        return persistable;
    }

    private void writeIt(String name, Object obj, String dataStore) throws PersistenceIsParentException, PersistenceInvalidNameException, PersistenceWriteException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.writeIt with name: " + name);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.writeIt: PersistenceManager was not correct initialized!!!");
            throw new PersistenceWriteException(this._pmNotInitializedException);
        }
        String key = this.nameToFileName(name, true, dataStore);
        if (key != null) {
            File file = new File(key);
            if (file.exists()) {
                if (file.isDirectory()) {
                    String errorMsg = "PersistenceManager.writeIt: Error! Passed name " + name + " is a directory! Key is:" + key;
                    Trace.trace(TRACE_MASKF, "File is Parent! Error!");
                    Trace.trace(TRACE_MASKF, errorMsg);
                    PersistenceIsParentException pexp = new PersistenceIsParentException(errorMsg);
                    throw pexp;
                }
            } else {
                int lastSeparator = key.lastIndexOf(File.separatorChar);
                if (lastSeparator != -1) {
                    String directoryName = key.substring(0, lastSeparator);
                    File directory = new File(directoryName);
                    Trace.trace(TRACE_MASKD, "Making directories for " + directoryName);
                    directory.mkdirs();
                }
            }
        } else {
            String errorMsg = "PersistenceManager.writeIt: Error! Passed name " + name + " is invalid!";
            Trace.trace(TRACE_MASKF, "Invalid File name specified! Error!");
            Trace.trace(TRACE_MASKF, errorMsg);
            PersistenceInvalidNameException pexp = new PersistenceInvalidNameException(errorMsg);
            throw pexp;
        }
        this.writeObject(key, obj);
        Trace.trace(TRACE_MASKT, "< PersistenceManager.writeIt with key " + key);
    }

    private String writeAChild(String parentName, Object data, String dataStore) throws PersistenceIsChildException, PersistenceInvalidNameException, PersistenceWriteException {
        Trace.trace(TRACE_MASKT, "> PersistenceManager.writeAChild for: " + parentName);
        if (this._isNotInitialized) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.writeAChild: PersistenceManager was not correct initialized!!!");
            throw new PersistenceWriteException(this._pmNotInitializedException);
        }
        String parentKey = this.nameToFileName(parentName, true, dataStore);
        String childKey = null;
        if (parentKey == null) {
            String errorMsg = "PersistenceManager.writeAChild: Error! Passed parent name " + parentName + " is invalid! Created key: " + parentKey;
            Trace.trace(TRACE_MASKF, "Invalid File name specified! Error!");
            Trace.trace(TRACE_MASKF, errorMsg);
            PersistenceInvalidNameException pexp = new PersistenceInvalidNameException(errorMsg);
            throw pexp;
        }
        childKey = this.makeChildKey(parentKey);
        this.writeObject(childKey, data);
        childKey = this.fileNameToName(childKey, dataStore);
        Trace.trace(TRACE_MASKT, "< PersistenceManager.writeAChild with childKey: " + childKey);
        return childKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(String uniqueKey, Object obj) throws PersistenceWriteException {
        Trace.trace(TRACE_MASKF, "> PersistenceManager.writeObject with name: " + uniqueKey);
        try {
            byte[] encoding = obj instanceof Persistable ? PersistenceManager.encode((Persistable)obj) : PersistenceManager.encode((PersistentData)obj);
            Object object = pmLock;
            synchronized (object) {
                File file = new File(uniqueKey);
                file.delete();
                file.createNewFile();
                FileOutputStream fileOutput = new FileOutputStream(file);
                fileOutput.write(encoding);
                fileOutput.close();
            }
        }
        catch (IOException exp) {
            Trace.trace(TRACE_MASKF, "PersistenceManager.writeObject: Could not write!");
            Trace.trace(TRACE_MASKF, "Failing Object key: " + uniqueKey);
            Trace.trace(TRACE_MASKF, "Failing Object: " + obj.toString());
            Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
            Trace.trace(TRACE_MASKF, exp);
            PersistenceWriteException pexp = new PersistenceWriteException(exp);
            new FrameworkLog(classLogInfo, 32, exp).log();
            throw pexp;
        }
        Trace.trace(TRACE_MASKF, "< PersistenceManager.writeObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map readList(List names, String dataStore) throws PersistenceReadException, PersistenceClassNotFoundException, PersistencePersistentDataConstructorNotFoundException, PersistenceUnsupportedVersionException {
        Trace.trace(TRACE_MASKF, "> PersistenceManager.readList");
        HashMap<String, Object> objects = new HashMap<String, Object>(names.size());
        if (names != null) {
            Iterator it = names.iterator();
            while (it.hasNext()) {
                File newObject = null;
                Object object = pmLock;
                synchronized (object) {
                    newObject = this.lookup((String)it.next(), dataStore);
                }
                if (newObject == null || !newObject.isFile() || newObject.length() <= 0L) continue;
                String name = this.fileNameToName(newObject.getAbsolutePath(), dataStore);
                objects.put(name, this.decode(newObject, name));
            }
        }
        Trace.trace(TRACE_MASKF, "< PersistenceManager.readList, size: " + objects.size());
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreUpgradeData(ZipInputStream inStream, ZipEntry entry) throws IOException {
        int bytesRead;
        Object directory;
        Trace.trace(TRACE_MASKF, "> PersistenceManager.restoreUpgradeData (single)");
        String fileName = this.nameToFileName(entry.getName(), false, this._persDataStorePrefix);
        Trace.trace(TRACE_MASKF, "Restore: " + fileName);
        int lastSeparator = fileName.lastIndexOf(File.separatorChar);
        if (lastSeparator != -1) {
            String directoryName = fileName.substring(0, lastSeparator);
            directory = new File(directoryName);
            Trace.trace(TRACE_MASKD, "Making directories for " + directoryName);
            ((File)directory).mkdirs();
        }
        File file = new File(fileName);
        directory = pmLock;
        synchronized (directory) {
            file.delete();
            file.createNewFile();
        }
        int bufferSize = 4096;
        byte[] readBuffer = new byte[bufferSize];
        FileOutputStream fileOutput = new FileOutputStream(file);
        BufferedOutputStream bufferOutput = new BufferedOutputStream(fileOutput, bufferSize);
        while ((bytesRead = inStream.read(readBuffer, 0, bufferSize)) != -1) {
            bufferOutput.write(readBuffer, 0, bytesRead);
        }
        bufferOutput.close();
        inStream.closeEntry();
        Trace.trace(TRACE_MASKF, "< PersistenceManager.restoreUpgradeData (single)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveUpgradeData(ZipOutputStream zipStream, String name) throws FileNotFoundException, IOException {
        boolean entryCreated;
        block17: {
            boolean isUpgradeData;
            File persistentFile;
            block15: {
                FileInputStream fileInput;
                block16: {
                    Trace.trace(TRACE_MASKF, "> PersistenceManager.saveUpgradeData (single): " + name);
                    entryCreated = false;
                    persistentFile = this.lookup(name, this._persDataStorePrefix);
                    if (persistentFile == null || persistentFile.isDirectory()) break block17;
                    fileInput = new FileInputStream(persistentFile);
                    ObjectInputStream objectInput = null;
                    isUpgradeData = false;
                    try {
                        Object var11_11;
                        try {
                            objectInput = new ObjectInputStream(fileInput);
                            int version = objectInput.readInt();
                            isUpgradeData = objectInput.readBoolean();
                        }
                        catch (IOException e) {
                            if (objectInput != null) {
                                try {
                                    objectInput.close();
                                }
                                catch (IOException ee) {
                                    // empty catch block
                                }
                                objectInput = null;
                                fileInput = null;
                            } else {
                                try {
                                    fileInput.close();
                                }
                                catch (IOException ee) {
                                    // empty catch block
                                }
                                fileInput = null;
                            }
                            Trace.trace(TRACE_MASKT, "Deleting corrupted file \"" + persistentFile.getPath() + '\"');
                            persistentFile.delete();
                            var11_11 = null;
                            if (objectInput != null) {
                                objectInput.close();
                                objectInput = null;
                                fileInput = null;
                                break block15;
                            }
                            if (fileInput != null) {
                                fileInput.close();
                                fileInput = null;
                            }
                            break block15;
                        }
                        var11_11 = null;
                        if (objectInput == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        if (objectInput != null) {
                            objectInput.close();
                            objectInput = null;
                            fileInput = null;
                            throw throwable;
                        }
                        if (fileInput == null) throw throwable;
                        fileInput.close();
                        fileInput = null;
                        throw throwable;
                    }
                    objectInput.close();
                    objectInput = null;
                    fileInput = null;
                    break block15;
                }
                if (fileInput != null) {
                    fileInput.close();
                    fileInput = null;
                }
            }
            if (isUpgradeData) {
                Trace.trace(TRACE_MASKF, "writing data for: " + name);
                FileInputStream upgradeInput = new FileInputStream(persistentFile);
                String storedName = this.fileNameToName(name, this._persDataStorePrefix);
                ZipEntry zipEntry = new ZipEntry(storedName);
                long fileLength = persistentFile.length();
                zipStream.putNextEntry(zipEntry);
                entryCreated = true;
                byte[] fileContent = new byte[(int)fileLength];
                int result = upgradeInput.read(fileContent);
                zipStream.write(fileContent, 0, fileContent.length);
                zipStream.closeEntry();
            }
        }
        Trace.trace(TRACE_MASKF, "< PersistenceManager.saveUpgradeData (single). ZipEntry created: " + entryCreated);
        return entryCreated;
    }

    private File lookup(String name, String dataStore) {
        File file = new File(this.nameToFileName(name, false, dataStore));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    private String nameToFileName(String name, boolean checkName, String dataStore) {
        Trace.trace(TRACE_MASKD, "> PersistenceManager.nameToFileName from: " + name);
        String fileName = name;
        if (!name.startsWith(dataStore)) {
            fileName = !checkName || this.isValidName(name) ? dataStore + name.replace('.', File.separatorChar) : null;
        }
        Trace.trace(TRACE_MASKD, "< PersistenceManager.nameToFileName is: " + fileName);
        return fileName;
    }

    private String fileNameToName(String fileName, String dataStore) {
        Trace.trace(TRACE_MASKD, "> PersistenceManager.fileNameToName from: " + fileName);
        String newName = fileName;
        if (fileName.startsWith(dataStore)) {
            newName = fileName.substring(dataStore.length());
        }
        newName = newName.replace(File.separatorChar, '.');
        Trace.trace(TRACE_MASKD, "< PersistenceManager.fileNameToName is: " + newName);
        return newName;
    }

    private boolean isValidName(String name) {
        int nameLength = name.length();
        if (nameLength > 0) {
            for (int i = 0; i < nameLength; ++i) {
                if (ALLOWEDCHARS.indexOf(name.charAt(i)) != -1) continue;
                Trace.trace(TRACE_MASKT, "<> PersistenceManager.isValidName: Name is invalid: " + name);
                Trace.trace(TRACE_MASKT, "<> PersistenceManager.isValidName: index: " + i + " invalid char: " + name.charAt(i));
                return false;
            }
        } else {
            Trace.trace(TRACE_MASKT, "<> PersistenceManager.isValidName: Name is invalid (name length == 0!)");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeChildKey(String parentKey) throws PersistenceIsChildException, PersistenceWriteException {
        Trace.trace(TRACE_MASKD, "> PersistenceManager.makeChildKey for parent: " + parentKey);
        File parentDirectory = new File(parentKey);
        if (!parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        String childKey = null;
        String fileName = null;
        if (parentDirectory.isDirectory()) {
            boolean fileCreated = false;
            while (!fileCreated) {
                childKey = parentKey + "." + GENERATED_KEY_START + Long.toString(System.currentTimeMillis());
                fileName = childKey.replace('.', File.separatorChar);
                File childFile = new File(fileName);
                try {
                    Object object = pmLock;
                    synchronized (object) {
                        fileCreated = childFile.createNewFile();
                    }
                }
                catch (IOException exp) {
                    Trace.trace(TRACE_MASKF, "PersistenceManager.makeChildKey: Could not write!");
                    Trace.trace(TRACE_MASKF, "Failing parentKey: " + parentKey);
                    Trace.trace(TRACE_MASKF, "Failing childKey: " + childKey);
                    Trace.trace(TRACE_MASKF, "Exception: " + exp.getMessage());
                    Trace.trace(TRACE_MASKF, exp);
                    PersistenceWriteException pexp = new PersistenceWriteException(exp);
                    throw pexp;
                }
            }
        } else {
            String errorMsg = "PersistenceManager.makeChildKey: Error! Passed name " + parentKey + " is a child, cannot be parent!";
            Trace.trace(TRACE_MASKF, "File is not direcory! Error!");
            Trace.trace(TRACE_MASKF, errorMsg);
            PersistenceIsChildException pexp = new PersistenceIsChildException(errorMsg);
            throw pexp;
        }
        Trace.trace(TRACE_MASKD, "makeChildKey is: " + fileName);
        Trace.trace(TRACE_MASKD, "< PersistenceManager.makeChildKey");
        return fileName;
    }
}

